CREATE or REPLACE PROCEDURE proc_create_matrix_report (v_StateName CHAR) IS

v_CountyName station2.county_name%type;
v_MaxCounty station2.county_name%type;

CURSOR c_Counties IS
	SELECT UNIQUE(county_name)
		FROM station2
		WHERE state_name = v_StateName
		ORDER BY county_name;
BEGIN

dbms_output.put_line('SPOOL H:/joe/'||TRANSLATE(TRIM(v_StateName), ' ', '_')||'/'||TRANSLATE(TRIM(v_StateName), ' ', '_')||'_'||TRANSLATE(TRIM(v_CountyName), ' ', '_')||'_matrix.txt');
dbms_output.put_line('SELECT RES.fk_parameter_code AS "Code", PAR.short_name01||'' ''||PAR.short_name02||'' ''||PAR.short_name03 as "Short Name", PAR.long_name as "Long Name",');

OPEN c_Counties;
dbms_output.enable(10000000);
SELECT MAX(county_name) INTO v_MaxCounty
	FROM station2
	WHERE state_name = v_StateName;
dbms_output.put_line('SUM(CASE WHEN state_name='''||TRIM(v_StateName)||''' THEN 1 ELSE 0 END) AS "'||TRIM(v_StateName)||' Totals",');

LOOP
	FETCH c_Counties INTO v_CountyName;
	EXIT WHEN c_Counties%NOTFOUND;
	IF v_CountyName = v_MaxCounty THEN
		dbms_output.put_line('SUM(CASE WHEN county_name='''||TRIM(v_CountyName)||''' THEN 1 ELSE 0 END) AS "'||TRIM(v_CountyName)||'"');
	ELSE
		dbms_output.put_line('SUM(CASE WHEN county_name='''||TRIM(v_CountyName)||''' THEN 1 ELSE 0 END) AS "'||TRIM(v_CountyName)||'",');
	END IF;
END LOOP;

CLOSE c_Counties;
dbms_output.put_line('FROM storet_owner.result RES, storet_owner.sample SAM, station2 STA, parameter PAR');
dbms_output.put_line('WHERE RES.fk_parameter_code = PAR.code');
dbms_output.put_line('and RES.fk_sample_code_isn=SAM.sample_code_isn');
dbms_output.put_line('and SAM.fk_computer_sequence_number=STA.computer_sequence_number');
dbms_output.put_line('and STA.state_name='''||trim(v_StateName)||'''');
dbms_output.put_line('GROUP BY RES.fk_parameter_code,PAR.long_name,PAR.short_name01||'' ''||PAR.short_name02||'' ''||PAR.short_name03;');
dbms_output.put_line('SPOOL OFF');
END;
/
SHOW ERRORS;